//___________________________________________________________________
//___________________________________________________________________
//  Copyright : 2021 BY HOLTEK SEMICONDUCTOR INC
//  File Name : Uart.c
// Description: 
//Targer Board: 
//   MCU      : BH67F2265
//   Author   : ming
//   Date     : 20210308
//   Version  : V00
//   History  :
//___________________________________________________________________
//___________________________________________________________________
#include "common.h"



/********************************************************************
Function:	DEFINE
********************************************************************/
#define		cmd_return_op1adnum			30
#define		cmd_return_op2adnum			31
#define		cmd_adjust_bandgap_up		32
#define		cmd_adjust_bandgap_down		33
#define		cmd_data_to_pref			34
#define		cmd_data_to_rom				35
#define		cmd_adjust_daco_up			37
#define		cmd_adjust_daco_down		38
#define		UCR1_8_N_1     				0x80      //8bits-Data  NONE-Parity 1bit-Stop Format
#define 	UCR1_7_O_1     				0x0B0     //7bits-Data  Odd-Parity  1bit-Stop Format
#define		UCR1_7_E_1     				0x0A0     //7bits-Data  Even-Parity 1bit-Stop Format
#define		UCR1_9_N_1     				0x0C0     //9bits-Data  NONE-Parity 1bit-Stop Format
#define		UCR1_8_O_1    				0x0F0     //8bits-Data  Odd-Parity  1bit-Stop Format
#define		UCR1_8_E_1     				0x0E0     //8bits-Data  Even-Parity 1bit-Stop Format
#define		UCR1_8_N_2     				0x88      //8bits-Data  NONE-Parity 2bits-Stop Format
#define		UCR1_7_O_2     				0x0B8     //7bits-Data  Odd-Parity  2bits-Stop Format
#define		UCR1_7_E_2     				0x0A8     //7bits-Data  Even-Parity 2bits-Stop Format
#define		UCR1_9_N_2     				0x0C8     //9bits-Data  NONE-Parity 2bits-Stop Format
#define		UCR1_8_O_2     				0x0F8     //8bits-Data  Odd-Parity  2bits-Stop Format
#define		UCR1_8_E_2     				0x0E8     //8bits-Data  Even-Parity 2bits-Stop Format
#define		UCR2Data       				0x0E4     //Enable TXEN RXEN BRGH RIE 
#define		UCR2Data1       			0x0Ef     //Enable TXEN RXEN BRGH RIE 
#define		BRGData        				12		  //8mhz      //Baud=38400,BRGH=1,



volatile	u8	gu8v_rx_guide;
volatile	u8	gu8v_tx_guide;
volatile	__byte_type	gu8v_uart_flag;
volatile	u8	array_uart_txbuff[12];
volatile	u8	array_uart_rxbuff[6];

/********************************************************************
Function:	Key_Scan
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void Uart_Init(void)
{
//	_umd = 1;	
	_pcs13 = 0;//set tx rx pin
	_pcs12 = 1;//set tx rx pin
	_pcs11 = 0;//set tx rx pin
	_pcs10 = 1;//set tx rx pin
	
	_txrxps0 = 1;
	
			
	
    _ucr1 = UCR1_8_N_1;     //enable UART function,8bits-Data  NONE-Parity 1bit-Stop Format
    _ucr2 = UCR2Data1;       //enable TXEN,RXEN,Hige Speed Baud Rate, Receiver interrupt enable 
	_rie = 1;
	#ifndef	Debug
   		_brg = BRGData;         //38400 Baud Rate	
	#else
   		_brg = 12;         //38400 Baud Rate	
	  		
	#endif

//	_euti = 1;      			//UART interrupt enable
	_ure = 1;
	_rie = 1;      			//UART interrupt enable	
	_rxen = 1;
	_uarten = 1;
}

/********************************************************************
Function:	Key_Scan
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void Uart_off(void)
{
	_uarten = 0;
	_ucr1 = 0;
	_ucr2 = 0;	

	
	_pcs13 = 0;//set tx rx pin
	_pcs12 = 0;//set tx rx pin
	_pcs11 = 0;//set tx rx pin
	_pcs10 = 0;//set tx rx pin
	
}


/********************************************************************
Function:	UART_ISR
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
//@------------uart--------------@

void __attribute((interrupt(UART_VECTOR)))  UART_ISR()
{	
	u8	lu8v_isr_temp0;
		//clear urf flag
	   	if(_perr || _nf || _ferr || _oerr)		// error found?
	   	{
	   	   lu8v_isr_temp0 = _usr;				//read USR to clear error flag 
	   	   lu8v_isr_temp0 =  _txr_rxr;				//read USR to clear error flag 	   	       
	   	}
	   	else									// no error found
	   	{
	   	   if(_rxif)							//RXR	data register has available	data
	   	   {

			for(lu8v_isr_temp0= 0;lu8v_isr_temp0<6-1;lu8v_isr_temp0++)
			{
				array_uart_rxbuff[lu8v_isr_temp0] = array_uart_rxbuff[lu8v_isr_temp0+1];
			}
			array_uart_rxbuff[6-1] = _txr_rxr;
			lu8v_isr_temp0= (u8)(array_uart_rxbuff[0]+array_uart_rxbuff[1]+array_uart_rxbuff[2]+array_uart_rxbuff[3]+array_uart_rxbuff[4]);	
			if(array_uart_rxbuff[0] == 0x55 && array_uart_rxbuff[6-1]==lu8v_isr_temp0)
			{
				//gbv_rx_success = 1;
				if(array_uart_rxbuff[1]==0)
				{
					gu8a_heart_wave_data_uart = (array_uart_rxbuff[2]+(u16)array_uart_rxbuff[3]*256)/16;
					gu16v_pressure_uart = array_uart_rxbuff[4];
					
					gbv_uart_wave_data = 1;
				}
				else if(array_uart_rxbuff[1]==1)
				{
					//模拟测试
					gbv_bpm_start_uart = 1;
				}
				else if(array_uart_rxbuff[1]==2)
				{
					gbv_bpm_stop = 1;		
				}				
				else if(array_uart_rxbuff[1]==3)
				{
					gbv_bpmsample_start = 1;		
				}			
				else if(array_uart_rxbuff[1]==5)
				{
					gbv_getpeak_data = 1;		
				}					
								
			}		   	   	  
	   	   	  
	   	   	  GCC_NOP();
	   	   }
	   	   if(_txif)							//TXR	data register is empty
	   	   {
	   	   		gu8v_tx_guide++; 	   		
	   	   		if(gu8v_tx_guide<12)			//
	   	   		{
		   	   		_txr_rxr= array_uart_txbuff[gu8v_tx_guide];	  	   	   			
//	   	   			gu16v_an4_votage%256;		//send 0xaa to PC
	   	   		}
	   	   		else 
	   	   		{
//	   	   			gu8v_tx_guide=0;
					
	   	   		}
					
	   	   }
	   	}	
}


/********************************************************************
Function:	Key_Scan
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Uart_manage(void)
{
	if(gbv_rx_success == 1)
	{
		gbv_rx_success = 0;
		if(array_uart_rxbuff[0] == 47 && array_uart_rxbuff[5] == 10)
		{
			switch(array_uart_rxbuff[1])
			{
				//
				case	0xaa:

				break;
				
				default	:
				
				break;			
				
				
				
							
			}	
					
		}
		else
		{
			gu8v_rx_guide = 0;
			
		}
		
	}
	
}

/********************************************************************
Function:	
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Uart_TX_PEAK_DATA(u8	lu8v_NUM)
{
	array_uart_txbuff[0]	= 0x55;	
	array_uart_txbuff[1]	= 05;			
	array_uart_txbuff[2]	= lu8v_NUM;	
	array_uart_txbuff[3]	= gu16a_peak_pressure[lu8v_NUM]+20;	
	array_uart_txbuff[4]	= gu8a_peak_wave[lu8v_NUM];		
	array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];	
	_txr_rxr= array_uart_txbuff[0];					
	gu8v_tx_guide=0;	
	
}
/********************************************************************
Function:	
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Uart_TX_RAW_DATA(u16	lu8v_NUM)
{
	array_uart_txbuff[0]	= 0x55;	
	array_uart_txbuff[1]	= 00;			
	array_uart_txbuff[2]	= lu8v_NUM%256;	
	array_uart_txbuff[3]	= (lu8v_NUM/256)%256;	
	array_uart_txbuff[4]	= lu8v_NUM/256/256;		
	array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];	
	_txr_rxr= array_uart_txbuff[0];					
	gu8v_tx_guide=0;	
	
}

/********************************************************************
Function:	
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Uart_TX_BH32F52640_ADC_AUTO_TEST(u16	lu16v_tx_data)
{
	array_uart_txbuff[0]	= 0x55;	
	array_uart_txbuff[1]	= 00;			
	array_uart_txbuff[2]	= lu16v_tx_data%256;	
	array_uart_txbuff[3]	= lu16v_tx_data/256;	
	array_uart_txbuff[4]	= 00;		
	array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];	
	_txr_rxr= array_uart_txbuff[0];					
	gu8v_tx_guide=0;	
	
}


// /********************************************************************
// Function:	Key_Scan
// INPUT	:
// OUTPUT	:	
// NOTE	:   
// ********************************************************************/
// void Uart_Init(void)
// {
//    	GPIO_UART_TX_IO = 0;
// 	GPIO_UART_TX = 1;
// }


//// *******************************************************************
//// Function:	Key_Scan
//// INPUT	:
//// OUTPUT	:	
//// NOTE	:   
//// *******************************************************************
// void	Uart_putchar(u8	tx_data)
// {
// 	u8	i;
// 	_emi = 0;
// 	GPIO_UART_TX_IO = 0;
// 	GPIO_UART_TX = 1;
// 	for(i=0;i<9;i++)
// 	{
// 		if(i)
// 		{
// 			if(tx_data & 0x01)
// 			{
// 				GPIO_UART_TX =	1;					
// 			}
// 			else
// 			{
// 				GPIO_UART_TX =	0;						
// 			}
// 			tx_data = tx_data>>1;
// 		}
// 		else
// 		{
// 			GPIO_UART_TX =	0;			
// 		}
// 		GCC_DELAY(UART_TX_DELAY);	
// 	}
// 	GPIO_UART_TX =	1;		
// 	GCC_DELAY(UART_TX_DELAY);	
// 	_emi = 1;	
// 	_txr_rxr = 1;
// }


/********************************************************************
Function:	
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	Uart_TX_RESULT(void)
{
		array_uart_txbuff[0]	= 0x55;	
		array_uart_txbuff[1]	= 03;			
		array_uart_txbuff[2]	= gu16v_sys;	
		array_uart_txbuff[3]	= gu16v_dia;
		array_uart_txbuff[4]	= gu8v_heart;		
		array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];			
		_txr_rxr= array_uart_txbuff[0];					
		gu8v_tx_guide=0;	

}


/********************************************************************
Function:	Sys_Measure
INPUT	:
OUTPUT	:	
NOTE	:   
********************************************************************/
void	UART_TX_MEASURING()
{
		array_uart_txbuff[0]	= 0x55;	
		array_uart_txbuff[1]	= 00;			
		array_uart_txbuff[2]	= gu8v_wave_uart_buff%256;	
		array_uart_txbuff[3]	= gu8v_wave_uart_buff/256;	
		array_uart_txbuff[4]	= 0;		
		array_uart_txbuff[5]	= array_uart_txbuff[0]+array_uart_txbuff[1]+array_uart_txbuff[2]+array_uart_txbuff[3]+array_uart_txbuff[4];			
		_txr_rxr= array_uart_txbuff[0];					
		gu8v_tx_guide=0;

}